/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.protect;

import java.util.Optional;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import org.magmafoundation.magma.common.utils.ShortenedStackTrace;

public class InjectionProcessor {
    @Nullable
    public static String getErroringMixin(Throwable error) {
        String annot;
        Throwable cause = ShortenedStackTrace.findCause((Throwable)error);
        String message = cause.getMessage();
        if (message.contains(annot = "annotation on")) {
            String function = InjectionProcessor.getRangeFromChars(annot, " could not find", message);
            if (function == null) {
                return null;
            }
            String json = InjectionProcessor.getJsonFromString(message);
            if (json == null) {
                return null;
            }
            return json + ":" + function;
        }
        return InjectionProcessor.getJsonFromString(message);
    }

    @Nullable
    private static String getRangeFromChars(String startIndex, String endIndex, String message) {
        int index = message.indexOf(startIndex) + startIndex.length() + 1;
        try {
            return message.substring(index, message.indexOf(endIndex, index));
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Nullable
    private static String getJsonFromString(String message) {
        int index = message.indexOf(".mixins.json");
        if (index == -1) {
            return null;
        }
        int start = message.substring(0, index).lastIndexOf(" ");
        if (start == -1) {
            return null;
        }
        int end = message.indexOf(" ", index);
        if (end == -1) {
            return null;
        }
        String raw = message.substring(start + 1, end);
        if (raw.contains("(")) {
            raw = raw.substring(0, raw.indexOf("("));
        }
        return raw;
    }

    @Nullable
    public static String getModID(Throwable error) {
        String file = InjectionProcessor.getErroringMixin(error);
        if (file == null) {
            return null;
        }
        int index = file.indexOf(".mixins.json");
        if (index == -1) {
            return null;
        }
        return file.substring(0, index);
    }

    @Nullable
    public static IModInfo getModInfo(Throwable error) {
        ModList modList = ModList.get();
        if (modList == null) {
            return null;
        }
        String modid = InjectionProcessor.getModID(error);
        if (modid == null) {
            return null;
        }
        Optional modContainerById = modList.getModContainerById(modid);
        return modContainerById.map(ModContainer::getModInfo).orElse(null);
    }
}

